	SENDER EQU 1
	LISTENER EQU 2
	MODE EQU SENDER
	BIG_SIZE EQU 8000h
CR	equ	0dh
LF	equ	0ah
if MODE EQ SENDER
	PACKETS_TO_SEND EQU 100
else
	PACKETS_TO_SEND EQU 80
endif

SAVE_ALL	MACRO
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	bp
		push	ds
		push	es
	ENDM

UNSAVE_ALL	MACRO
		pop		es
		pop		ds
		pop		bp
		pop		di
		pop		si
		pop		dx
		pop		cx
		pop		bx
		pop		ax
	ENDM

code	segment word public
	assume	cs:code, ds:code
start:
		mov		ax, cs
		mov		ds, ax
		mov		es, ax
		mov		dx,	0378h
		in		al, dx	; data
		inc		dx
		in		al, dx	; status
		inc		dx
		in 		al, dx	; control
		in		al,21h	; Remove mask for IRQ7
		and		al,7Fh
		out		21h, al
		mov		al,LF
		mov		dx,0
		mov		ah,0
		mov		al,LF
		int		17h
		mov		dx, 37ah
		in 		al, dx	; control
		or		al, 10h
		out		dx, al
temp:
		push	ax
		pop		ax
		jmp		temp
		mov		al,"2"
		call	print_it
		mov		al,CR
		call	print_it
		mov		dx, 037Ah
		in 		al, dx	; control
		or		al, 10h
		out		dx, al
		mov		ah,00
		mov		al,"2"
		mov		dx, 0
		int	17h
		mov		ah,00
		mov		al,CR
		mov		dx, 0
		int	17h
		mov		ah,00
		mov		al,LF
		mov		dx, 0
		int	17h
		; prevent interrupts
		in		al, 21h
		;or		al, 80h
		and		al, 7Fh
;		out		21h, al
dummy:
		call	scrub_buffer
		jmp		dummy
;		call	setup_reads


print_it	PROC NEAR
	mov		dx, 0378h
	out		dx, al
	inc		dx
	in		al, dx
	inc		dx
	mov		al, 0Dh
	out		dx, al
	mov		al, 0Ch
	out		dx, al
;	mov		dx, 0379h
;	in		al, dx
	ret
print_it	ENDP

wait_until_received:
if MODE EQ LISTENER
		cmp	recv_count, 0
		je	wait_until_received
endif
again:
		mov		si, offset ether_pack
		mov		ah, 04h		; Access_type function
		mov		cx, (offset dummy_byte - offset ether_pack)
		SAVE_ALL
		cld
		mov		bp,sp			;we use bp to access the original regs.
		call	id_packet
		int		100
		UNSAVE_ALL
		inc	send_count
		cmp	send_count, PACKETS_TO_SEND
		jl	again
labx:
		SAVE_ALL
		UNSAVE_ALL
		jmp	labx
		ret

send_count	db 0
recv_count	db	0
big_offset	dw 0
small_buffer	db	100h dup (?)
big_buffer	db	BIG_SIZE dup (?)
ether_pack	db 255, 255, 255, 255, 255, 255
			db 255, 255, 255, 255, 255, 255
ether_id	db 	0, 0, 0, 0, 0, 0
			db 10, 10
			db 1, 2, 3, 4, 5, 6, 7, 8, 9, 10
			db 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
			db 21, 22, 23, 24, 25, 26, 27, 28, 29, 30
			db 31, 32, 33, 34, 35, 36, 37, 38, 39, 40
			db 41, 42, 43, 44, 45, 46, 47, 48, 49, 50
			db 51, 52, 53, 54, 55, 56, 57, 58, 59, 60
			db 61, 62, 63, 64, 65, 66, 67, 68, 69, 70
dummy_byte	db	0

id_packet	PROC NEAR
		push	ax
		mov	al, send_count
		mov	ether_id, al
		pop	ax
		ret
id_packet	ENDP

scrub_buffer PROC	NEAR
		mov cx,(BIG_SIZE/2)
		mov	di, offset big_buffer
		mov	ax, 00
		rep	STOSW
		ret
scrub_buffer ENDP

setup_reads	PROC	NEAR
		mov		di, offset give_buffer
		mov		ah, 02h		; Access_type function
		mov		al, 01h		; Bluebook
		mov		bx, -1
		mov		cx, 00h		; Type length
		mov		dl, 00h
		SAVE_ALL
		cld
		mov		bp,sp			;we use bp to access the original regs.
		int		100
		UNSAVE_ALL
		ret
setup_reads	ENDP


give_buffer:
		cmp		ax, 00h
		jne		got_it
		mov		ax, cs
		mov		es,	ax
		mov		di, offset small_buffer
		retf
got_it:
		push	si
		push	di
		push		cx
		mov		si, offset small_buffer
		mov		di, offset big_buffer
		add		di, big_offset
		push	di
		rep movsb
		pop		di
		pop		cx
		add		big_offset, cx
		pop		di
		pop		si
		inc		recv_count
		cmp		recv_count, 0Ah
		jle		lab01
		nop
lab01:
		retf

waste_time	PROC	NEAR
		mov		dx, 1h
waste0:
		mov		cx, 0ffh
waste1:
		SAVE_ALL
		UNSAVE_ALL
		loop	waste1
		dec		dx
		jnz		waste0
		ret
waste_time	ENDP

code	ENDS

		END
